/*
 * Decompiled with CFR 0.152.
 */
package com.android.customer.data.repository;

import com.android.core.data.AndroidRepository;
import com.android.core.domain.model.BaseResponse;
import com.android.core.domain.model.GenericResponse;
import com.android.core.utils.params.QueryParamTypes;
import com.android.customer.domain.model.ACustomerDto;
import com.android.customer.domain.use_case.InsertCustomer;
import com.dto.LoginDto;
import com.service.SettingLoader;
import com.utility.ConvertStr;
import com.utility.DbConnection;
import com.utility.LockCode;
import com.utility.LockReader;
import com.utility.Paging;
import com.utility.Pair;
import com.utility.SoftwareInfo;
import com.utility.TncException;
import javax.annotation.Resource;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.springframework.transaction.TransactionStatus;

@Component
public class CustomerRepository
extends AndroidRepository<ACustomerDto> {
    @Resource
    @Lazy
    private InsertCustomer insertCustomer;

    public CustomerRepository(DbConnection dbConnection) {
        super(dbConnection);
    }

    @Nullable
    protected Paging.PageSqlData queryWithDefaultPaging(SettingLoader settingsLoader) {
        if (settingsLoader.doNotSendCustomerData() && !settingsLoader.isSelectPartyEnabled()) {
            return null;
        }
        SoftwareInfo softwareInfo = new SoftwareInfo(this.getJdbc(settingsLoader.getLogin()));
        LockReader reader = new LockReader(this.getJdbc(settingsLoader.getLogin()));
        String selectPart = "SELECT c.C_Code AS code, c.C_Name AS [name], '' AS lastName, \n c.National_Code AS nationalCode, c.Zip_Code AS postalCode, c.C_AliasName nickname, \n c.C_Tel AS tellNo, c.C_Mobile AS mobileNo, \n c.C_Address AS [address], IsNull(c.[Cust_City], '') AS city, \n CASE WHEN (c.C_Code_C IS NULL OR RTrim(LTrim(c.C_Code_C)) = '') \n  THEN c.C_Code ELSE c.C_Code_C END AS partyCustomCode, \n";
        selectPart = settingsLoader.is5PriceCustEnabled() ? selectPart + " IsNull(c.SelectType, 0) AS partyPriceNo, \n" : selectPart + " -1 AS partyPriceNo, \n";
        selectPart = selectPart + this.getPartyAccRemainOpenSelect(settingsLoader, softwareInfo, reader) + this.getPartyAccRemainSelect(settingsLoader, reader) + this.getPartyCheckRemainOpenSelect(settingsLoader, softwareInfo, reader) + this.getPartCheckRemainSelect(settingsLoader, reader) + " IsNull(c.Kharid, 0) AS buyer, IsNull(c.Forosh, 0) AS seller, \n IsNull(c.Vaseteh, 0) AS middleMan, c.City_Code AS categoryCode, \n" + this.getPartyMidManCommission() + " (SELECT TOP 1 VASETEH_CODE FROM CustomerVaseteh WHERE C_CODE = c.C_CODE) AS midManCode, \n CASE WHEN IsNull(C.col_code_bed, '') + IsNull(C.Moien_Code_Bed, '') \n  + IsNull(C.Tafzili_Code_Bed, '') <> '' THEN 'true' ELSE 'false' END debtor, \n CASE WHEN IsNull(C.col_code_bes, '') + IsNull(C.Moien_Code_Bes, '') \n  + IsNull(C.Tafzili_Code_Bes, '') <> '' THEN 'true' ELSE 'false' END creditor, \n C.Etebar credit, IsNull(C.FactOutOfEtebar, 0) overdueInvoice, \n IsNull(C.SanadOutOfEtebar, 0) overdueDocuments, \n IsNull(C.latitude, 0.0) latitude, IsNull(C.longitude, 0.0) longitude, \n IsNull(c.InListSiah, 0) blacklisted, IsNull(C.UserCodeCust, 0) userCode, \n IsNull(C.MohlatTasvieh, 0) dueDate, IsNull(C.Porsant, 0) discountPercent \n FROM CUSTOMER c \n";
        Pair hasJoinQuery = this.getRemainJoinString(settingsLoader, softwareInfo);
        String beforePart = "";
        if (((Boolean)hasJoinQuery.getLeft()).booleanValue()) {
            beforePart = " IF (OBJECT_ID('tempdb..#MandehView') IS NOT NULL) \n DROP TABLE #MandehView \n select * into #MandehView from W_Calc_Mandeh_Customer \n";
        }
        String joins = " LEFT JOIN CITY ON c.City_Code = CITY.City_Code \n" + (String)hasJoinQuery.getRight() + this.getCheckRemainJoinString(settingsLoader, softwareInfo);
        if (settingsLoader.userHasLimitedAccessToCustomers()) {
            joins = joins + " INNER JOIN (SELECT * FROM RMUserArtAccess \n WHERE UserId = " + settingsLoader.getLogin().getUserCodeInc() + " \n AND IsNull(DataTypeId, 0) = 1) RMUA ON RMUA.Articleid = c.C_Code";
        }
        String wherePart = "IsNull(c.IsActive, 0) = 1 ";
        wherePart = wherePart + (settingsLoader.onlySendMidManCustomers() ? " AND C.C_Code IN (SELECT C_Code FROM CustomerVaseteh WHERE VASETEH_CODE = " + ConvertStr.toQuotedSqlStr((String)settingsLoader.getMidManId()) + ")" : "");
        wherePart = wherePart + (softwareInfo.isRestaurant() ? " AND isNULL(Res_cust, 0) = 1 " : "");
        if (settingsLoader.isMoienFilterEnabled()) {
            wherePart = wherePart + " AND c.City_Code NOT IN (select [value] from dbo.StringSplit(@cityCodes,',')) ";
        }
        return Paging.PageSqlData.builder().declare(settingsLoader.isMoienFilterEnabled() ? " DECLARE @cityCodes NVARCHAR(300)=(SELECT CityCodesFilter from USERDB where UserCodeInc = " + settingsLoader.getLogin().getUserCodeInc() + ") \n" : "").beforePart(beforePart).selectSqlStr(selectPart).joinsStr(joins).whereStr(wherePart).alias("c").keyField("[code]").build();
    }

    private String getPartyMidManCommission() {
        return "Case \nwhen (c.Vaseteh = 1) then c.Vaseteh_Porsant \nELSE (SELECT TOP 1 Vaseteh_Porsant FROM CustomerVaseteh WHERE C_CODE = c.C_CODE) \nEND AS midManCommission, \n";
    }

    @Language(value="SQL")
    private String getPartyAccRemainOpenSelect(SettingLoader settingsLoader, SoftwareInfo softwareInfo, LockReader reader) {
        if (settingsLoader.isSendCustomerRemainDisabled() || !softwareInfo.isNetworkMode()) {
            return " 0 as partyAccRemainOpen, 0 as partyAccNatureOpen, '' as partyAccNatureStrOpen, \n";
        }
        return " IsNull(ABS(ROUND(IsNull(CRemain.Mandeh, 0) + IsNull(CustomerRemain, 0) + \n IsNull(midManRemain, 0) + IsNull(MandePayCust, 0) + IsNull(MandePayVaseteh, 0), \n" + this.getRoundingPrice(settingsLoader, reader) + ")), 0) as partyAccRemainOpen, \n CASE WHEN (IsNull(Round(CRemain.Mandeh, 0), 0) + IsNull(CustomerRemain, 0) + \n   IsNull(midManRemain, 0) + IsNull(MandePayCust, 0) + IsNull(MandePayVaseteh, 0)) > 0 THEN 1 \n  WHEN (IsNull(Round(CRemain.Mandeh, 0), 0) + IsNull(CustomerRemain, 0) + \n   IsNull(midManRemain, 0) + IsNull(MandePayCust, 0) + isNull(MandePayVaseteh, 0)) < 0 THEN -1 \n  ELSE 0 END AS partyAccNatureOpen, \n CASE WHEN(IsNull(Round(CRemain.Mandeh, 0), 0) + IsNull(CustomerRemain, 0) + \n   IsNull(midManRemain, 0) + IsNull(MandePayCust, 0) + IsNull(MandePayVaseteh, 0)) > 0 THEN '\u0628\u062f' \n  WHEN(IsNull(Round(CRemain.Mandeh, 0), 0) + IsNull(CustomerRemain, 0) + \n   IsNull(midManRemain, 0) + IsNull(MandePayCust, 0) + IsNull(MandePayVaseteh, 0)) < 0 THEN '\u0628\u0633' \n  ELSE '' END AS partyAccNatureStrOpen, \n";
    }

    @Language(value="SQL")
    private String getPartyAccRemainSelect(SettingLoader settingsLoader, LockReader reader) {
        if (settingsLoader.isSendCustomerRemainDisabled()) {
            return " 0 as partyAccRemain, 0 as partyAccNature, '' as partyAccNatureStr, \n";
        }
        return " IsNull(abs(Round(CRemain.Mandeh, " + this.getRoundingPrice(settingsLoader, reader) + ")), 0) as partyAccRemain, \n IsNull(CRemain.Type_Mandeh, 0) AS partyAccNature, CASE IsNull(CRemain.Type_Mandeh, 0) \n WHEN 0 THEN '' WHEN 1 THEN '\u0628\u062f' WHEN -1 THEN '\u0628\u0633' END AS partyAccNatureStr, \n";
    }

    @Language(value="SQL")
    private String getPartyCheckRemainOpenSelect(SettingLoader settingsLoader, SoftwareInfo softwareInfo, LockReader reader) {
        if (settingsLoader.isSendPartyOpenChecksRemainDisabled() || !softwareInfo.isNetworkMode()) {
            return " 0 as partyChRemainOpen, \n";
        }
        return " IsNull(ABS(ROUND(TChRemainTmp.Sumcheck, " + this.getRoundingPrice(settingsLoader, reader) + ")), 0) as partyChRemainOpen, \n";
    }

    @Language(value="SQL")
    private String getPartCheckRemainSelect(SettingLoader settingsLoader, LockReader reader) {
        if (settingsLoader.isSendPartyOpenChecksRemainDisabled()) {
            return " 0 as partyChRemain, \n";
        }
        return " IsNull(ABS(ROUND(TChRemain.chRemain, " + this.getRoundingPrice(settingsLoader, reader) + ")), 0) AS partyChRemain, ";
    }

    private Pair<Boolean, String> getRemainJoinString(SettingLoader settingsLoader, SoftwareInfo softwareInfo) {
        if (settingsLoader.isSendCustomerRemainDisabled()) {
            return new Pair((Object)false, (Object)"");
        }
        String result = " LEFT JOIN #MandehView CRemain ON c.C_Code = CRemain.C_Code \n";
        if (!softwareInfo.isNetworkMode()) {
            return new Pair((Object)true, (Object)result);
        }
        return new Pair((Object)true, (Object)(result + " LEFT JOIN( \n  SELECT SUM(sumF) - SUM(SumK) CustomerRemain, C1.C_code \n  FROM ( \n   SELECT F.C_code, IsNull(Sum(\n    CASE WHEN(f.FNaghd + F.FCard + F.FNesiyeh) = 0 \n     THEN A_few * A_price ELSE F.FNesiyeh END), 0) sumF, 0 sumK \n   FROM Tmpfacture F \n   INNER JOIN TmpFactart Fa On F.Id = Fa.IdFacture \n   WHERE Ftype='F' AND Kind = 0 AND IsNull(Fac_CodeK, 0) = 0 AND IsNull(Fac_CodeF, 0) = 0 \n    AND IsNull(Fac_CodeY, 0) = 0 AND IsNull(Fac_CodeX, 0) = 0 AND IsNull(Fac_CodeZ, 0) = 0 \n   GROUP BY F.C_code, F.Ftype \n   UNION\n   SELECt F.C_code, 0 Sumf, IsNull(SUM(CASE WHEN(f.FNaghd + F.FCard + F.FNesiyeh) = 0 \n    THEN A_few * A_price ELSE F.FNesiyeh END), 0) SumK \n   FROM Tmpfacture F \n   INNER JOIN TmpFactart Fa ON F.Id = Fa.IdFacture \n   WHERE Ftype = 'K' AND Kind = 0 AND IsNull(Fac_CodeK, 0) = 0 AND IsNull(Fac_CodeF, 0) = 0 \n    AND IsNull(Fac_CodeY, 0) = 0 AND IsNull(Fac_CodeX, 0) = 0 AND IsNull(Fac_CodeZ, 0) = 0 \n   GROUP BY F.C_code, F.Ftype \n   UNION \n   SELECT F.R_Cuscode C_code, IsNull(SUM(r_few * R_Cost), 0) sumF, 0 sumK FROM RQTitle F \n   INNER JOIN RQDETAIL Fa ON F.RQIndex = Fa.RQIndex WHERE F.RqType = 'F' AND IsNull(ShowOrHide, 1) = 1 \n   GROUP BY F.R_CusCode,F.RqType \n   UNION \n   SELECT F.R_Cuscode C_code, 0 sumF, IsNull(SUM(r_few * R_Cost), 0) sumK FROM RQTitle F \n   INNER JOIN RQDETAIL Fa ON F.RQIndex = Fa.RQIndex WHERE F.Rqtype = 'K' AND IsNull(ShowOrHide, 1) = 1 \n   GROUP BY F.R_CusCode, F.RqType \n  ) C1 GROUP BY C1.c_code \n ) C2 ON C2.C_Code = C.C_code \n LEFT JOIN (SELECT SUM(sumF) - SUM(SumK) midManRemain, CV1.C_codeVaseteh \n  From ( \n   SELECT F.C_codeVaseteh, IsNull(SUM( \n    CASE WHEN(f.FNaghd + F.FCard + F.FNesiyeh) = 0 THEN A_few * A_price ELSE F.FNesiyeh END), 0) sumF, \n    0 sumK FROM Tmpfacture F INNER JOIN TmpFactart Fa ON F.Id = Fa.IdFacture \n   WHERE Ftype = 'F' AND Kind = 0 AND IsNull(Fac_CodeK, 0) = 0 \n    AND IsNull(Fac_CodeF, 0) = 0 AND IsNull(Fac_CodeY, 0) = 0 \n    AND IsNull(Fac_CodeX, 0) = 0 AND IsNull(Fac_CodeZ, 0) = 0 \n   GROUP BY F.C_codeVaseteh, F.FType \n   UNION \n   SELECT F.C_codeVaseteh, 0 Sumf, IsNull(SUM(CASE WHEN(f.FNaghd + F.FCard + F.FNesiyeh) = 0 \n    THEN A_few * A_price else F.FNesiyeh END), 0) SumK \n   FROM Tmpfacture F \n   INNER JOIN TmpFactart Fa ON F.Id = Fa.IdFacture \n   WHERE FType = 'K' AND Kind = 0 AND IsNull(Fac_CodeK, 0) = 0 \n    AND IsNull(Fac_CodeF, 0) = 0 AND IsNull(Fac_CodeY, 0) = 0 \n    AND IsNull(Fac_CodeX, 0) = 0 AND IsNull(Fac_CodeZ, 0) = 0 \n   GROUP BY F.C_codeVaseteh, F.FType \n  ) CV1 GROUP BY CV1.C_codeVaseteh \n ) CV2 ON CV2.C_codeVaseteh = C.C_code \n LEFT JOIN( \n  SELECT SUM(IsNull(SumPar, 0) - IsNull(SumDar, 0)) MandePayCust, C3.C_Code\n  FROM( \n   SELECT SUM(IsNull(SNaghd, 0) + IsNull(SCheck, 0) + IsNull(SCard, 0)) SumDar, \n    0 SumPar, C_Code \n   FROM TmpSanad \n   WHERE AfoType = 0 AND IsNull(sanad_code, 0) = 0 \n   GROUP BY AfoType, C_Code \n   UNION \n   SELECT 0 SumDar, sum(IsNull(SNaghd, 0) + IsNull(Scheck, 0) + IsNull(Scard, 0)) SumPar, C_Code \n   FROM TmpSanad WHERE AfoType = 1 AND IsNull(sanad_code, 0) = 0 \n   GROUP BY AfoType, C_Code \n  ) C3 Group by C3.C_Code \n ) C4 ON C4.C_Code = C.C_code \n LEFT JOIN (\n  SELECT SUM(IsNull(sumpar, 0) - IsNull(sumdar, 0)) MandePayVaseteh, CV3.C_codeVaseteh \n  FROM( \n   SELECT SUM(IsNull(SNaghd, 0) + IsNull(SCheck, 0) + IsNull(SCard, 0)) SumDar, \n    0 SumPar, C_codeVaseteh \n   FROM TmpSanad \n   WHERE AfoType = 0 AND IsNull(sanad_code, 0) = 0 \n   GROUP BY AfoType, C_codeVaseteh \n   UNION \n   SELECT 0 SumDar, SUM(IsNull(SNaghd, 0) + IsNull(Scheck, 0) + IsNull(Scard, 0)) SumPar, C_codeVaseteh \n   FROM TmpSanad WHERE AfoType = 1 AND IsNull(sanad_code, 0) = 0 \n   GROUP BY AfoType, C_codeVaseteh \n  ) CV3 \n  GROUP BY CV3.C_codeVaseteh \n ) CV4 ON CV4.C_codeVaseteh = C.C_Code \n"));
    }

    @Language(value="SQL")
    private String getCheckRemainJoinString(SettingLoader settingsLoader, SoftwareInfo softwareInfo) {
        if (settingsLoader.isSendPartyOpenChecksRemainDisabled()) {
            return "";
        }
        String result = " LEFT JOIN ( \n  SELECT C_Code_Source, SUM(IsNull(cust, 0)) AS chRemain FROM [check] ch \n  WHERE ch.vosool = 0 AND (Ch.Daryaft_Pardakht = 1) AND (ch.Show_Daftar = 1) \n";
        if (settingsLoader.isEmkanVosoolCheckKharjiEnabled()) {
            result = result + " OR (ch.Vosool = 1 AND (ch.Sel_Check = 1 \n AND (ch.Sanad_Code <> 0 OR Sanad_Code2 <> 1)) AND (VosolKharji = 0 OR VosolKharji IS NULL)) \n";
        }
        result = result + " GROUP BY ch.C_Code_Source \n ) TChRemain ON TChRemain.C_Code_Source = c.C_Code \n";
        if (softwareInfo.isNetworkMode()) {
            result = result + " LEFT JOIN (SELECT SUM(ISNULL(Scheck, 0)) Sumcheck, C_Code \n FROM TmpSanad WHERE IsNull(Sanad_code, 0) = 0 \n Group by AfoType, C_Code \n) TChRemainTmp on TChRemainTmp.C_Code = C.C_Code";
        }
        return result;
    }

    private double getRoundingPrice(SettingLoader settingsLoader, LockReader reader) {
        return reader.isLockEnabled(LockCode.KIT_FLOAT_DOCUMENT) ? settingsLoader.getRoundNumber() : 0.0;
    }

    @NotNull
    protected QueryParamTypes queryParamType() {
        return QueryParamTypes.CUSTOMER;
    }

    protected BaseResponse<GenericResponse> insert(ACustomerDto item, LoginDto login, TransactionStatus status) throws TncException {
        return this.makeBaseGenericResponse(status, () -> this.insertCustomer.invoke(item));
    }
}

